// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-6 Principles of mass transfer
//Example 6_3_1 Page:399
//Title: Diffusion of ethanol through water
//================================================
model Ex6_3_1

//===============
//Parameter section
parameter Real Da(unit = "m^2/s") = 0.74E-09 "Diffusivity of ethanol";
parameter Real z(unit = "mm") = 2 "Stagnent film thickness";
parameter Real rho1(unit = "kg/m^3") = 972.8 "Density of mixture at 1";
parameter Real rho2(unit = "kg/m^3") = 988.1 "Density of mixture at 2";
parameter Real c_e1(unit = "%") = 16.8 "Ethanol concentration at point 1";
parameter Real c_e2(unit = "%") = 6.8 "Ethanol concentration at point 2";
parameter Real MA(unit = "kg/kmol") = 46.05 "Moleular weight of ethanol";
parameter Real MB(unit = "kg/kmol") = 18.02 "Molecular weight of water";

//==============
//Variable section
Real xa2(unit = "-") "Mole fraction of ethanol at 2";
Real xb2(unit = "-") "Mole fraction of water at 2";
Real xa1(unit = "-") "Mole fraction of ethanol at 1";
Real xb1(unit = "-") "Mole fraction of water at 1";
Real M1(unit = "kg/kmol") "Average molecular weight at 1";
Real M2(unit = "kg/kmol") "Average molecular weight at 2";
Real cav(unit = "mol/m^3") "Average Concentration";
Real xbm(unit = "-") "Average mole fraction";
Real Na(unit = "kmol/m^2.s") "Flux of A";

//===============
//Equation section
equation
xa1 = (c_e1/MA)/((c_e1/MA)+((100-c_e1)/MB)) ; // Mole fraction of A at 1
xb2 = 1-xa2 ; // Mole fraction of A at 2
xa2 = (c_e2/MA)/((c_e2/MA)+((100-c_e2)/MB)) ; // Mole fraction of A at 1
xb1 = 1-xa1 ; // Mole fraction of B at 2
M1 = xa1*MA + xb1*MB ;
M2 = xa2*MA + xb2*MB ; 
cav = ((rho1/M1)+(rho2/M2))/2 ;
xbm = (xb1 + xb2)/2 ;
Na = Da*cav*(xa1 - xa2)/((z/1000)*xbm) ; 
 // z is divided by 1000 to convert mm to m
end Ex6_3_1;
//=========================================================
