// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-7 Principles of unsteady state and convective mass transfer
//Example 7_1_1 Page:431
//Title: Unsteady state diffusion in a slab of agar gel
//================================================
model Ex7_1_1

//===============
//Parameter section
parameter Real co(unit = "kmol/m^3") = 0.1 "Initial concentration of urea";
parameter Real c1(unit = "kmol/m^3") = 0 "Concentration of solute in pure water";
parameter Real K(unit = "-") = 1 "Distribution coefficient at equilibrium";
parameter Real m(unit = "-") = 0 "Term involved in graph";
 // Since kc is very large (zero resistance)
parameter Real Da(unit = "m^2/s") = 4.72E-10 "Diffusivity of the solution";
parameter Real x(unit = "mm") = 0 "Length of center";
parameter Real t(unit = "h") = 10 "Time required for diffusion";
parameter Real A(unit = "mm") = 10.16 "Distance between two parellel plates";
parameter Real B(unit = "mm") = 2.54 "Length from the surface";

//==============
//Varible section
Real c_1(unit = "kmol/m^3") "Concentration at a distance from center for case 1";
Real c_2(unit = "kmol/m^3") "Concentration at a distance from center for case 1";
Real c_3(unit = "kmol/m^3") "Concentration at a distance from center for case 2";
Real x1(unit = "-") "Ratio of length between 2 parellel plates";
Real n1(unit = "-") "Term involved in graph";
Real n2(unit = "-") "Term involved in graph";
Real X(unit = "-") "Unsteady state term in case 1";
Real X1(unit = "-") "Unsteady term in case 2";
Real x2(unit = "-") "Ratio of length from center";

//===============
//Equation section
equation
x1 = A/(1000*2) ; // Half the thickness of slab
X = Da*t*3600/(x1^2) ; // Term involved in unsteady state
n1 = x/x1 ; // Graphical term
 // For the corresponding X,m and n the valure of Y from graph is 0.275 from figure 5.3-5
0.275 = (c1-c_1)/(c1-co) ; // Concentration at the midpoint of slab
x2 = B/1000 ; // Length of slab from center
n2 = x2/x1 ; // Graphical term
 // The value of Y for n2 is 0.172 from figure 5.3-5, page : 340
0.172 = (c1-c_2)/(c1-co) ; // Concentration at length x2
X1 = X/n2^2 ; // Term in unsteady state
 // Corresponding value of Y is 0.002 from figure 5.3-5, page : 340
0.002 = (c1-c_3)/(c1-co) ; // Concentration at half the thickness of slab 
end Ex7_1_1;
//==================================================================
