// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-7 Principles of unsteady state and convective mass transfer
//Example 7_2_1 Page:431
//Title: Vaporizing and convective mass transfer
//================================================
model Ex7_2_1

//==============
//Parameter section
parameter Real P(unit = "atm") = 2 "Total pressure of the system";
parameter Real k_y(unit = "kmol/m^2.s.mol frac") = 6.78E-05 "Mass transfer coefficient";
parameter Real pa1(unit = "atm") = 0.2 "Partial pressure of A at 1";
parameter Real pa2(unit = "atm") = 0 "Partial pressure of A at 2";

//==============
//Variable section
Real ya1(unit = "-") "Mole fraction of A at 1";
Real ya2(unit = "-") "Mole fraction of A at 2";
Real yb1(unit = "-") "Mole fraction of B at 1";
Real yb2(unit = "-") "Mole fraction of B at 2";
Real yBM(unit = "-") "Logarithmic average of mole fraction";
Real ky(unit = "kmol/m^2.s.mol frac") "Mass transfer coefficient based on mole fraction";
Real kG(unit = "kmol/m^2.s.atm") "Gas phase mass transfer coefficient";
Real Na1(unit = "kmol/m^2.s") "Mass transfer flux";
Real Na2(unit = "kmol/m^2.s") "Mass transfer flux";

//==============
//Equation section 
equation
ya1 = pa1/P ; // Mole fraction of A at 1
ya2 = pa2/P ; // Mole fraction of A at 2
yb1 = 1-ya1 ; // Mole fraction of B at 1
yb2 = 1-ya2 ; // Mole fraction of B at 2
yBM = (yb2 - yb1)/(log(yb2/yb1)) ; // Logarithmic average of mole fraction
ky = k_y/yBM ; // Mass transfer coefficient
kG = ky/P ; // Mass transfer coefficient
Na1 = ky*(ya1-ya2) ; // Mass transfer flux 
Na2 = kG*(pa1-pa2) ; // Mass transfer flux
end Ex7_2_1;
//==================================================
