// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-7 Principles of unsteady state and convective mass transfer
//Example 7_5_4 Page:461
//Title: Diffusion of A through Nondiffusing B and C
//================================================
model Ex7_5_4

//=============
//Parameter section
parameter Real pb1(unit = "atm") = 0.4 "Partial pressure of B at 1";
parameter Real pc1(unit = "atm") = 0.2 "Partial pressure of C at 1";
parameter Real pa1(unit = "atm") = 0.4 "Partial pressure of A at 1";
parameter Real pa2(unit = "atm") = 0.1 "Partial pressure of A at 2";
parameter Real z1(unit = "atm") = 0 "Length 1";
parameter Real z2(unit = "atm") = 0.005 "Length 2";
parameter Real P(unit = "atm") = 1 "Total pressure";
parameter Real R(unit = "Pa.m^3/kmol.K") = 8314.3 "Universal gas constant";
parameter Real T(unit = "K") = 298 "Temperature at which diffusion takes place";
parameter Real Dac(unit = "m^2/s") = 6.75E-05 "Diffusivity of A to C";
parameter Real Dab(unit = "m^2/s") = 2.02E-05 "Diffusivity of A to B";

//=============
//Variable section
Real x_b(unit = "-") "Mole fraction of liquid of B";
Real x_c(unit = "-") "Mole fraction of liquid of C";
Real Dam(unit = "m^2/s") "Mean diffusivity of A";
Real pi1(unit = "atm") "Partial pressure of 'ith' component at 1";
Real pi2(unit = "atm") "partial pressure of 'ith' component at 2";
Real pim(unit = "atm") "Logarithmic mean average of pressure";
Real Na(unit = "kmol/m^2.s") "Mass transfer flux";


//==============
//Equation section
equation
x_b = pb1/(1-pa1) ; // Mole fraction of B, since xb = pb
x_c = pc1/(1-pa1) ; // Mole fraction of C, since xc = pc
Dam = 1/((x_b/Dab)+(x_c/Dac)) ; // Mean diffusivity
pi1  = P - pa1 ; // Partial pressure of ith component at 1
pi2 = P - pa2 ; // Partial pressure of ith component at 2
pim = (pi2 - pi1)/(log(pi2/pi1)) ; // Logarithmic mean pressure
Na = (Dam*P/(R*T*(z2-z1)*pim))*(pa1*101325-pa2*101325) ; // Mass transfer flux
 // 101325 is multiplied to convert atm to Pascal
end Ex7_5_4;
//==============================================
