// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-7 Principles of unsteady state and convective mass transfer
//Example 7_6_2 Page:466
//Title: Transition region diffusion of He and N2
//================================================
model Ex7_6_2

//=================
//Parameter section
parameter Real xa1(unit = "-") = 0.8 "Mole fraction of A at 1";
parameter Real xa2(unit = "-") = 0.2 "Mole fraction of A at 2";
parameter Real Dab(unit = "m^2/s") = 6.98E-05 "Diffusivity of A to B";
parameter Real Ma(unit = "kg/kmol") = 28.02 "Molecular weight of A";
parameter Real Mb(unit = "kg/kmol") = 4.003 "Molecular weight of B";
parameter Real P(unit = "atm") = 0.1 "Total pressure";
parameter Real r(unit = "m") = 2.5E-06 "The pore radius";
parameter Real R(unit = "Pa.m^3/kmol.K") = 8314.3 "Universal gas constant";
parameter Real T(unit = "K") = 298 "Temerature of the diffusion";
parameter Real L(unit = "m") = 0.01 "Length of capillary";

//================
//Variable section
Real Dka(unit = "m^2/s") "Knudsen diffusivity";
Real Nb_Na(unit = "-") "Ratio of moles of B to A";
Real alpha(unit = "-") "Diffusivity";
Real Dab_act(unit = "m/s^2") "Actual diffusivity";
Real Na1(unit = "kmol/m^2.s") "Mass transfer flux";
Real Na2(unit = "kmol/m^2.s") "Mass transfer flux";
Real Na3(unit = "kmol/m^2.s") "Mass transfer flux";
Real Dna1(unit = "m^2/s") "Molecular diffusivity in transition region";
Real Dna2(unit = "m^2/s") "Molecular diffusivity in transition region";

//=================
//Equation section
equation
 Dka = 97*r*(T/Ma)^0.5 ; // Knudsen diffusivity
 Nb_Na = -sqrt(Ma/Mb) ; // Ratio of Nb to Na
 alpha = 1+Nb_Na ; // Diffusivity
 Dab_act = Dab/P ; // Actual diffusivity
 Na1 = (Dab_act*P*101325/(alpha*R*T*L))*(log(((1-alpha*xa2) + Dab/(P*Dka))/((1-alpha*xa1) + Dab/(P*Dka)))) ; // Flux
 Dna1 = 1/((1/(Dab/P))+(1/Dka)) ; // Molecular diffusivity 
 Na2 = (Dna1*P*101325/(R*T*L))*(xa1-xa2) ; // Mass transfer flux
  // 101325 is multiplied to convert atm to Pa
 Dna2 = 1/(((1-alpha*((xa1+xa2)/2))/(Dab/P)) + (1/Dka)) ; // Molecular diffusivity
 Na3 = (Dna2*P*101325/(R*T*L))*(xa1-xa2) ; // Mass transfer flux
  // 101325 is multiplied to convert atm to Pa
end Ex7_6_2;
//========================================================
