// C.J. Geankopolis, Transport processes and Unit operations, 3rd Edn, Prentice-Hall International

//Chapter-9: Drying of process materials
//Example 9.9-1 Page 553
//Title: Drying slab of wood when diffusion of moisture controls
//================================================
model Ex9_9_1

//===============
// Libraries 
extends Modelica.Constants;

//===============
//Parameter section
parameter Real DL(unit = "m^2/h") = 2.97E-06 "Diffusion coefficient of the moisture";
parameter Real d(unit = "mm") = 25.4 "Thickness of the slab";
parameter Real Xt1(unit = "-") = 0.29 "Initial moisture content";
parameter Real X_e(unit = "-") = 0.04 "Equilibrium moisture content";
parameter Real Xt(unit = "-") = 0.09 "Final moisture content";

//===============
//Variable section
Real X1(unit = "-") "Free moisture content";
Real X(unit = "-") "Available moisture content";
Real x1(unit = "m") "Half slab thickness";
Real t_1(unit = "h") "Time required for drying analytically";
Real t_2(unit = "h") "Time required for drying using graphical method";

//===============
//Equation section
equation
x1 = d/(2*1000) ; // Half thickness of the slab
X1 = Xt1 - X_e ; // Free moisture content
X = Xt - X_e ; // Available moisture
 // x1 is divided by 1000 to convert mm to m
t_1 = (4*x1^2/(pi^2*DL))*log(8*X1/(pi^2*X)) ; // Time required for drying
 // From the plot, for the corresponding ordinate and abcssica the reading is 0.56
t_2 = x1^2*0.56/DL ; // Time required for drying in graphical method
end Ex9_9_1;
//=====================================================
